/* This is the code to be used with the LabView program        */
/* Geert Langereis, Februari 2011                              */
/* Board starts with prompt ">", a response is expected:       */
/* "I" : Interval mode, input A only                           */
/* "K" : Interval mode, input B only                           */
/* "J" : Interval mode, input A and B                          */
/* "S" : Scope mode, input A only                              */
/* "U" : Scope mode, input B only                              */
/* "T" : Scope mode, input A and B                             */
const int Baudrate = 19200;
const int Analog_Input_Pin_A = 0;               
const int Digital_Input_Pin_A = 2; // the pin that the heart-rate sensor is attached which contains INT0
const int Analog_Input_Pin_B = 1; 
const int Digital_Input_Pin_B = 3; // the pin that the heart-rate sensor is attached which contains INT1
int Mode;

void setup()
{
  Serial.begin(Baudrate);           // For sending data to the computer over USB
  Serial.print(">");
  while (Serial.available()==0){
  }
  Mode = Serial.read();
  switch (Mode)
  {
  case 'I':  // Interval mode, input A only
    pinMode(Digital_Input_Pin_A, INPUT);
    attachInterrupt(0, Send_Interval_A, RISING);  // Attach to INT0
    break;
  case 'K':  // Interval mode, input B only
    pinMode(Digital_Input_Pin_B, INPUT);
    attachInterrupt(1, Send_Interval_B, RISING);  // Attach to INT1
    break;    
  case 'J': // Interval mode, input A and B
    pinMode(Digital_Input_Pin_A, INPUT);
    pinMode(Digital_Input_Pin_B, INPUT);
    attachInterrupt(0, Send_Interval_A, RISING);  // Attach to INT0
    attachInterrupt(1, Send_Interval_B, RISING);  // Attach to INT1    
    break;
  default:  // Scope mode, S = A only, T = B only, U = A and B
    cli();                    // disable interrupts while messing with their settings
    TCCR1A = 0x00;            // clear default timer settings, this kills the millis() function,
    TCCR1B = 0x00;            // timer in normal mode
    TCCR1B |= (1 << WGM12);   // Configure timer 1 for CTC mode
    TCCR1B |= (0 << CS12);    // Set timer prescaling by setting 3 bits
    TCCR1B |= (1 << CS11);    // 001=1, 010=8, 011=64, 100=256, 101=1024
    TCCR1B |= (1 << CS10);
    TIMSK1 |= (1 << OCIE1A);  // Enable CTC interrupt with OCF1A flag in TIFR1
    //OCR1A  = 124;             // Set CTC compare value, results into 500Hz for fI/O = 8MHz
    OCR1A  = 248;    // this will be 250Hz
    sei();                    // turn interrupts back on
  }
}

void loop() {
  // nothing to do, its all in the interrupt handlers!
}  

unsigned long LastTime_A, NewTime_A, LastTime_B, NewTime_B;

void Send_Interval_A()
{ 
  NewTime_A = micros();  // Resolution 4us, only one overrurn in 70 minutes
  Serial.print("A");
  Serial.println(NewTime_A-LastTime_A, HEX); 
  LastTime_A = NewTime_A;
}

void Send_Interval_B()
{ 
  NewTime_B = micros();  // Resolution 4us, only one overrurn in 70 minutes
  Serial.print("B");
  Serial.println(NewTime_B-LastTime_B, HEX); 
  LastTime_B = NewTime_B;
}

ISR(TIMER1_COMPA_vect)            // when timer counts down it fires this interrupt for scope-mode
{  
  if ((Mode=='S') || (Mode=='U'))
  {
    int val_A = analogRead(Analog_Input_Pin_A);
    Serial.write((val_A >> 2));
  }
  if ((Mode=='T') || (Mode=='U'))
  {  
    int val_B = analogRead(Analog_Input_Pin_B);
    Serial.write((val_B >> 2));
  }
}
























